/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.shape;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_265;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.PortalShapeSerialization;
import qouteall.imm_ptl.core.portal.shape.RectangularPortalShape;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.q_misc_util.my_util.BoxPredicateF;
import qouteall.q_misc_util.my_util.Mesh2D;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.TriangleConsumer;

public final class SpecialFlatPortalShape
implements PortalShape {
    @NotNull
    public final Mesh2D mesh;

    public SpecialFlatPortalShape(@NotNull Mesh2D mesh) {
        this.mesh = mesh;
        this.mesh.enableTriangleLookup();
    }

    public static void init() {
        PortalShapeSerialization.addSerializer(new PortalShapeSerialization.Serializer<SpecialFlatPortalShape>("specialFlat", SpecialFlatPortalShape.class, SpecialFlatPortalShape::serialize, SpecialFlatPortalShape::deserialize));
    }

    @NotNull
    private class_2487 serialize() {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10566("shape", (class_2520)this.mesh.toTag());
        return compoundTag;
    }

    @Nullable
    private static SpecialFlatPortalShape deserialize(class_2487 tag) {
        Mesh2D m = Mesh2D.fromTag(tag.method_10562("shape"));
        if (m == null) {
            return null;
        }
        return new SpecialFlatPortalShape(m);
    }

    @Override
    public boolean isPlanar() {
        return true;
    }

    @Override
    public class_238 getBoundingBox(UnilateralPortalState portalState, boolean limitSize, double boxExpand) {
        return RectangularPortalShape.INSTANCE.getBoundingBox(portalState, limitSize, boxExpand);
    }

    @Override
    public double roughDistanceToPortalShape(UnilateralPortalState portalState, class_243 pos) {
        return RectangularPortalShape.INSTANCE.roughDistanceToPortalShape(portalState, pos);
    }

    @Override
    @Nullable
    public RayTraceResult raytracePortalShapeByLocalPos(UnilateralPortalState portalState, class_243 localFrom, class_243 localTo, double leniency) {
        double ny;
        RayTraceResult roughRayTrace = RectangularPortalShape.INSTANCE.raytracePortalShapeByLocalPos(portalState, localFrom, localTo, leniency);
        if (roughRayTrace == null) {
            return null;
        }
        double localX = roughRayTrace.hitPos().method_10216();
        double localY = roughRayTrace.hitPos().method_10214();
        double halfWidth = portalState.width() / 2.0;
        double halfHeight = portalState.height() / 2.0;
        double nx = localX / halfWidth;
        double boxR = Math.max(leniency, 1.0E-5);
        boolean intersectWithMesh = this.mesh.boxIntersects(nx - boxR, (ny = localY / halfHeight) - boxR, nx + boxR, ny + boxR);
        if (intersectWithMesh) {
            return roughRayTrace;
        }
        return null;
    }

    @Override
    public Plane getOuterClipping(UnilateralPortalState portalState) {
        return RectangularPortalShape.INSTANCE.getOuterClipping(portalState);
    }

    @Override
    public Plane getInnerClipping(UnilateralPortalState thisSideState, UnilateralPortalState otherSideState, Portal portal) {
        return RectangularPortalShape.INSTANCE.getInnerClipping(thisSideState, otherSideState, portal);
    }

    @Override
    public PortalShape getFlipped() {
        Mesh2D newMesh = new Mesh2D();
        for (int ti = 0; ti < this.mesh.getStoredTriangleNum(); ++ti) {
            if (!this.mesh.isTriangleValid(ti)) continue;
            int p0Index = this.mesh.trianglePointIndexes.getInt(ti * 3);
            int p1Index = this.mesh.trianglePointIndexes.getInt(ti * 3 + 1);
            int p2Index = this.mesh.trianglePointIndexes.getInt(ti * 3 + 2);
            newMesh.addTriangle(-this.mesh.pointCoords.getDouble(p0Index * 2), this.mesh.pointCoords.getDouble(p0Index * 2 + 1), -this.mesh.pointCoords.getDouble(p1Index * 2), this.mesh.pointCoords.getDouble(p1Index * 2 + 1), -this.mesh.pointCoords.getDouble(p2Index * 2), this.mesh.pointCoords.getDouble(p2Index * 2 + 1));
        }
        return new SpecialFlatPortalShape(newMesh);
    }

    @Override
    public PortalShape getReverse() {
        return this.getFlipped();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderViewAreaMesh(class_243 portalOriginRelativeToCamera, UnilateralPortalState portalState, TriangleConsumer vertexOutput, boolean isGlobalPortal) {
        double halfWidth = portalState.width() / 2.0;
        double halfHeight = portalState.height() / 2.0;
        class_243 localXAxis = portalState.getAxisW().method_1021(halfWidth);
        class_243 localYAxis = portalState.getAxisH().method_1021(halfHeight);
        for (int ti = 0; ti < this.mesh.getStoredTriangleNum(); ++ti) {
            if (!this.mesh.isTriangleValid(ti)) continue;
            int p0Index = this.mesh.getTrianglePointIndex(ti, 0);
            int p1Index = this.mesh.getTrianglePointIndex(ti, 1);
            int p2Index = this.mesh.getTrianglePointIndex(ti, 2);
            double p0x = this.mesh.getPointX(p0Index);
            double p0y = this.mesh.getPointY(p0Index);
            double p1x = this.mesh.getPointX(p1Index);
            double p1y = this.mesh.getPointY(p1Index);
            double p2x = this.mesh.getPointX(p2Index);
            double p2y = this.mesh.getPointY(p2Index);
            ViewAreaRenderer.outputTriangle(vertexOutput, portalOriginRelativeToCamera, localXAxis, localYAxis, p0x, p0y, p1x, p1y, p2x, p2y);
        }
    }

    @Override
    public boolean canCollideWith(Portal portal, UnilateralPortalState portalState, class_243 entityEyePos, class_238 entityBoundingBox) {
        boolean inFrontOfPortal = portal.isInFrontOfPortal(entityEyePos);
        if (!inFrontOfPortal) {
            return false;
        }
        return this.isBoxInPortalProjection(portalState, entityBoundingBox);
    }

    @Override
    public boolean isLocalBoxInPortalProjection(UnilateralPortalState portalState, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        boolean roughTest = RectangularPortalShape.INSTANCE.isLocalBoxInPortalProjection(portalState, minX, minY, minZ, maxX, maxY, maxZ);
        if (!roughTest) {
            return false;
        }
        double halfWidth = portalState.width() / 2.0;
        double halfHeight = portalState.height() / 2.0;
        return this.mesh.boxIntersects(minX / halfWidth, minY / halfHeight, maxX / halfWidth, maxY / halfHeight);
    }

    @Override
    public class_243 getMovementForPushingEntityOutOfPortal(Portal portal, UnilateralPortalState portalState, class_1297 entity, class_243 attemptedMove) {
        return RectangularPortalShape.INSTANCE.getMovementForPushingEntityOutOfPortal(portal, portalState, entity, attemptedMove);
    }

    @Override
    public PortalShape cloneIfNecessary() {
        return new SpecialFlatPortalShape(this.mesh.copy());
    }

    @Override
    public boolean roughTestVisibility(UnilateralPortalState portalState, class_243 cameraPos, boolean isIrisShaderOn) {
        return RectangularPortalShape.INSTANCE.roughTestVisibility(portalState, cameraPos, isIrisShaderOn);
    }

    public static SpecialFlatPortalShape createDefault() {
        return new SpecialFlatPortalShape(Mesh2D.createNewFullQuadMesh());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BoxPredicateF getInnerFrustumCullingFunc(Portal portal, class_243 cameraPos) {
        return RectangularPortalShape.INSTANCE.getInnerFrustumCullingFunc(portal, cameraPos);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BoxPredicateF getOuterFrustumCullingFunc(Portal portal, class_243 cameraPos) {
        return RectangularPortalShape.INSTANCE.getOuterFrustumCullingFunc(portal, cameraPos);
    }

    @Override
    public boolean shouldRenderInside(Portal portal, class_238 box) {
        return RectangularPortalShape.INSTANCE.shouldRenderInside(portal, box);
    }

    @Override
    public class_265 getThisSideCollisionExclusion(UnilateralPortalState portalState) {
        return RectangularPortalShape.INSTANCE.getThisSideCollisionExclusion(portalState);
    }

    @Override
    @Nullable
    public class_238 transformEntityActiveCollisionBox(Portal portal, class_238 box, class_1297 entity) {
        return RectangularPortalShape.INSTANCE.transformEntityActiveCollisionBox(portal, box, entity);
    }
}

